import alice.tucson.api.*;
import alice.logictuple.*;
import javax.swing.*;

/*Thread che si occupa di osservare i msg che gli notificano se qualche utente
 *ha lasciato la chat
 *
 *@author Rossella Rubino
 *@version agosto1 2004 
 */
public class AgentObserverLeave extends Thread {

	private JTextArea output;
    private TucsonContext context;
    private TupleCentreId myTC;

        public AgentObserverLeave(JTextArea output, AgentId aid, TupleCentreId id) throws Exception {
            this.output=output;
            this.myTC=id;
            context = Tucson.enterContext(new DefaultContextDescription(aid));
        }

        public void run(){
            try {
                while (true) {
                    LogicTuple msg=context.in(myTC,LogicTuple.parse("leave(_,_)"));
	                TupleArgument who=msg.getArg(0);
	                
                    output.append("System>  "+toFlatString(who.toString())+" lascia la chat\n");
                    output.setCaretPosition(output.getText().length());
                    System.out.println("System>  "+toFlatString(who.toString())+" lascia la chat\n");
                }
            } catch (Exception ex){
                ex.printStackTrace();
            }
        }
        
        /*metodo usato per eliminare gli apici all'inizio e alla fine di una stringa
	 	*
	 	*@param st stringa su cui lavorare
	 	*@return stringa senza apici
	 	*/
        private String toFlatString(String st){
            if (st.startsWith("'")&&st.endsWith("'")){
                return st.substring(1,st.length()-1);
            } else {
                return st;
            }
        }

    }